﻿var panelistPoints = {
    context: $("#panelistPoints"),
    panelistId: 0,
    datatable: null,
    refreshDataTable: function () {
        panelistPoints.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".v-panelistPointsTable").a4datatable({
            advancedFilter: true,
            ajaxAction: a4.getAction("GetPanelistPoints", "Panelists", "Panel", { panelistId: panelistPoints.panelistId }),
            columns: [
                { "Name": "SourceEnumVal", "Title": resources.Source, "Data": "SourceFormatted", "Type": "enum", "EnumType": "PointsSource" },
                { "Name": "OperationEnumVal", "Title": resources.Operation, "Data": "OperationFormatted", "Type": "enum", "EnumType": "PointsOperation" },
                { "Name": "Points", "Title": resources.Points, "Data": "Points", "Type": "numeric", "HideInSelector": true },
                { "Name": "DateTime", "Title": resources.DateTime, "Data": "DateTime", "Type": "datetime"},
                { "Name": "Message", "Title": resources.Message, "Data": "FormatedMessage", "Sortable": false }
            ],
            lengthMenu: [
                [10, 20, 50, 100, 500, 1000],
                ['10', '20', '50', '100', '500', '1000']
            ],
            defaultSorting: { Column: "DateTime", Ascending: false },
            displaySearchBox: false
        });
    },
    bindEvents: function () {
        $(document).on("click", ".h-addPanelistTransactionPoint", function () {
            panelPointCommon.addTransactionPointToPanelist("Single", "NewPointsTransaction", panelistPoints);
        });
    }
}

$(document).ready(function () {
    if ($(".v-panelistPointsTable").length > 0) {
        panelistPoints.panelistId = $("#PanelistId").val();
        panelistPoints.bindEvents();
        panelistPoints.initializeDataTable();
    }
});
